/*
	Copyright  2007, The MorphOS Team. All rights reserved.
	$Id: pc104_cz.c,v 1.7 2009/03/07 21:12:32 krashan Exp $

	Desc: Czech PC104/PC101 QWERTZ Keymap
	Lang: English
*/

#include <devices/keymap.h>

#define	VERSION		51
#define	REVISION	6
#define	KMDESC		"Czech keyboard (QWERTZ) with 101/104 keys"
#define	KMID		"pc104_cz 51.6"
#define KMNAME		"pc104_cz"
#define KMLANG      "etina"
#define KMLANGINT   "Czech"
#define KMCODEPAGE  "ISO-8859-2"

#define CONST const

extern CONST char  keymapname[];

extern CONST UBYTE lokeymaptypes[];
extern CONST IPTR  lokeymap[];
extern CONST UBYTE locapsable[];
extern CONST UBYTE lorepeatable[];

extern CONST UBYTE hikeymaptypes[];
extern CONST IPTR  hikeymap[];
extern CONST UBYTE hicapsable[];
extern CONST UBYTE hirepeatable[];

static const struct Resident ROMTag;

struct ExtendedKeyMapNode km =
{
	{
		NULL, NULL, NT_EXTENDED, 'E', (char*) keymapname
	},
	{
	(UBYTE *)lokeymaptypes,
	(IPTR  *)lokeymap,
	(UBYTE *)locapsable,
	(UBYTE *)lorepeatable,
	(UBYTE *)hikeymaptypes,
	(IPTR  *)hikeymap,
	(UBYTE *)hicapsable,
	(UBYTE *)hirepeatable
	},
	0,
	(struct Resident *)&ROMTag,
	0
};

CONST char keymapname[] = KMNAME;

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#define N KC_NOQUAL
#define S KCF_SHIFT
#define A KCF_ALT
#define C KCF_CONTROL
#define D KCF_DEAD
#define V KC_VANILLA
#define ST KCF_STRING
#define NOP KCF_NOP

CONST UBYTE lokeymaptypes[] =
{
	S|C,	/* 00 */
	V,		/* 01 */
	V,		/* 02 */
	V,		/* 03 */
	V,		/* 04 */
	V,		/* 05 */
	V,		/* 06 */
	V,		/* 07 */
	V,		/* 08 */
	V,		/* 09 */
	V,		/* 0A */
	S|C,	/* 0B */
	S|C,	/* 0C */
	S|C,  /* 0D */
	N,		/* 0E */
	N,	   /* 0F */
	V,		/* 10 q */
	V,		/* 11 w */
	V|D,	/* 12 e */
	V|D,	/* 13 r */
	V|D,	/* 14 t */
	V|D,	/* 15 z */
	V|D,	/* 16 u */
	V|D,	/* 17 i */
	V|D,	/* 18 o */
	V,		/* 19 p */
	S|A|C,	/* 1A */
	S|A|C,	/* 1B */
	N,	   /* 1C */
	N,		/* 1D */
	N,	   /* 1E */
	N,	   /* 1F */
	V|D,	/* 20 a */
	V|D,	/* 21 s */
	V|D,	/* 22 d */
	V|D,	/* 23 f */
	V|D,	/* 24 g */
	V|D,	/* 25 h */
	V|D,	/* 26 j */
	V|D,	/* 27 k */
	V,		/* 28 l */
	S|A|C,	/* 29 */
	S|A|C,	/* 2A */
	S|C,	/* 2B */
	N,		/* 2C */
	N,		/* 2D */
	N,		/* 2E */
	N,		/* 2F */
	V,		/* 30 */
	V|D,		/* 31 y */
	V,		/* 32 x */
	V|D,	/* 33 c */
	V,		/* 34 v */
	V,		/* 35 b */
	V|D,	/* 36 n */
	V,		/* 37 m */
	S|A|C,	/* 38 */
	S|A|C,	/* 39 */
	S|A|C,	/* 3A */
	N,		/* 3B */
	N,		/* 3C */
	N,		/* 3D */
	N,		/* 3E */
	N,		/* 3F */

};

CONST UBYTE hikeymaptypes[] =
{
	N|D,	/* 40 SPACE */
	N,		/* 41 BACKSPACE */
	ST|S,	/* 42 TAB */
	N,		/* 43 ENTER */
	C,		/* 44 RETURN */
	A,		/* 45 ESCAPE */
	N,		/* 46 DEL  */
	ST|S,	/* 47 INSERT ?? */
	ST|S,	/* 48 PAGE UP ?? */
	ST|S,	/* 49 PAGE DOWN ?? */
	N,		/* 4A NUMERIC PAD - */
	ST|S,	/* 4B F11 ?? */
	ST|S,	/* 4C CURSORUP*/
	ST|S,	/* 4D CURSORDOWN */
	ST|S,	/* 4E CURSORRIGHT */
	ST|S,	/* 4F CURSORLEFT */
	ST|S,	/* 50 F1 */
	ST|S,	/* 51 F2 */
	ST|S,	/* 52 F3 */
	ST|S,	/* 53 F4 */
	ST|S,	/* 54 F5 */
	ST|S,	/* 55 F6 */
	ST|S,	/* 56 F7 */
	ST|S,	/* 57 F8 */
	ST|S,	/* 58 F9 */
	ST|S,	/* 59 F10 */
	NOP,	/* 5A NUMLOCK */
	N,		/* 5B NUMPAD ) */
	N,		/* 5C NUMPAD / */
	N,		/* 5D NUMPAD * */
	N,		/* 5E NUMPAD + */
	ST,		/* 5F HELP */
	NOP,	/* 60 LEFT SHIFT*/
	NOP,	/* 61 RIGHT SHIFT */
	NOP,	/* 62 CAPS LOCK */
	NOP,	/* 63 CONTROL */
	NOP,	/* 64 LALT */
	NOP,	/* 65 RALT */
	NOP,	/* 66 LCOMMAND */
	NOP,	/* 67 RCOMMAND */
	NOP,	/* 68 LEFT MOUSE BUTTON*/
	NOP,	/* 69 RIGHT MOUSE BUTTON */
	NOP,	/* 6A MIDDLE MOUSE BUTTON */
	ST|S,	/* 6B SCR LOCK */
	ST|S,	/* 6C PRT SCREEN */
	ST|S,	/* 6D NUM LOCK */
	ST|A,	/* 6E PAUSE/BREAK ??*/
	ST|S,	/* 6F F12 ?? */
	ST|C,	/* 70 HOME ?? */
	ST|C,	/* 71 END ?? */
	NOP,	/* 72 */
	NOP,	/* 73 */
	NOP,	/* 74 */
	NOP,	/* 75 */
	NOP,	/* 76 */
	NOP,	/* 77 */
	NOP,	/* 78 */
	NOP,	/* 79 */
	NOP,	/* 7A */
	NOP,	/* 7B */
	NOP,	/* 7C */
	NOP,	/* 7D */
	NOP,	/* 7E */
	NOP		/* 7F */

};

#undef N
#undef S
#undef A
#undef C
#undef D
#undef V
#undef ST
#undef NOP

#undef STRING
#undef DEAD
#undef BYTES

#define STRING(x) (IPTR)(x)
#define DEAD(x)	  (IPTR)(x)
#define BYTES(b0, b1, b2, b3) (((UBYTE)(b3))<<0) | (((UBYTE)(b2))<<8) | (((UBYTE)(b1))<<16) | (((UBYTE)(b0))<<24)

#define N 0
#define D DPF_DEAD
#define M DPF_MOD

const UBYTE key_e[] =
{
	M, 16, M, 22,
	N, 236, N, 204,
	N, 0x05, N, 0x05,
	N, 0x85, N, 0x85,
	'e', 233, 236, 'e', 'e', 'e',
	'E', 201, 204, 'E', 'E', 'E',
};

const UBYTE key_z[] =
{
	M, 16, M, 22,
	N, 190, N, 174,
	N, 0x19, N, 0x19,
	N, 0x99, N, 0x99,
	'z', 'z', 190, 'z', 'z', 'z',
	'Z', 'Z', 174, 'Z', 'Z', 'Z',
};

const UBYTE key_y[] =
{
	M, 16, M, 22,
	N, 253, N, 221,
	N, 0x19, N, 0x19,
	N, 0x99, N, 0x99,
	'y', 253, 'y', 'y', 'y', 'y',
	'Y', 221, 'Y', 'Y', 'Y', 'Y',
};

const UBYTE key_u[] =
{
	M, 16, M, 22,
	N, 250, N, 218,
	N, 0x15, N, 0x15,
	N, 0x95, N, 0x95,
	'u', 250, 249, 'u', 'u', 'u',
	'U', 218, 217, 'U', 'U', 'U',
};

const UBYTE key_i[] =
{
	M, 16, M, 22,
	N, 237, N, 205,
	N, 0x09, N, 0x09,
	N, 0x89, N, 0x89,
	'i', 237, 'i', 'i', 'i', 'i',
	'I', 205, 'I', 'I', 'I', 'I',
};

const UBYTE key_o[] =
{
	M, 16, M, 22,
	N, 243, N, 211,
	N, 0x0f, N, 0x0f,
	N, 0x8f, N, 0x8f,
	'o', 243, 'o', 'o', 'o', 'o',
	'O', 211, 'O', 'O', 'O', 'O',
};

const UBYTE key_a[] =
{
	M, 16, M, 22,
	N, 225, N, 193,
	N, 0x01, N, 0x01,
	N, 0x81, N, 0x81,
	'a', 225, 'a', 'a', 'a', 'a',
	'A', 193, 'A', 'A', 'A', 'A',
};

const UBYTE key_f[] =
{
	N, 'f', N, 'F',	// [
	D, 1, D, 1,
	N, 0x06, N, 0x06,
	N, 0x86, N, 0x86,
};

const UBYTE key_g[] =
{
	N, 'g', N, 'G',	// ]
	D, 2, D, 2,
	N, 0x07, N, 0x07,
	N, 0x87, N, 0x87,
};

const UBYTE key_h[] =
{
	N, 'h', N, 'H',
	D, 3, D, 3,
	N, 0x08, N, 0x08,
	N, 0x88, N, 0x88,
};

const UBYTE key_j[] =
{
	N, 'j', N, 'J',
	D, 4, D, 4,
	N, 0x0a, N, 0x0a,
	N, 0x8a, N, 0x8a,
};

const UBYTE key_k[] =
{
	N, 'k', N, 'K',
	D, 5, D, 5,
	N, 0x0b, N, 0x0b,
	N, 0x8b, N, 0x8b,
};

const UBYTE key_n[] =
{
	M, 16, M, 22,
	N, 242, N, 210,
	N, 0x0e, N, 0x0e,
	N, 0x8e, N, 0x8e,
	'n', 'n', 242, 'n', '', 'n',
	'N', 'N', 210, 'N', '', 'N',
};

const UBYTE key_r[] =
{
	M, 16, M, 22,
	N, 248, N, 216,
	N, 0x0f, N, 0x0f,
	N, 0x8f, N, 0x8f,
	'r', 'r', 248, 'r', 'r', 'r',
	'R', 'R', 216, 'R', 'R', 'R',
};

const UBYTE key_t[] =
{
	M, 16, M, 22,
	N, 187, N, 171,
	N, 0x10, N, 0x10,
	N, 0x90, N, 0x90,
	't', 't', 187, 't', 't', 't',
	'T', 'T', 171, 'T', 'T', 'T',
};

const UBYTE key_s[] =
{
	M, 16, M, 22,
	N, 185, N, 169,
	N, 0x11, N, 0x11,
	N, 0x91, N, 0x91,
	's', 's', 185, 's', 's', 's',
	'S', 'S', 169, 'S', 'S', 'S',
};

const UBYTE key_d[] =
{
	M, 16, M, 22,
	N, 239, N, 207,
	N, 0x12, N, 0x12,
	N, 0x92, N, 0x92,
	'd', 'd', 239, 'd', 'd', 'd',
	'D', 'D', 207, 'D', 'D', 'D',
};

const UBYTE key_c[] =
{
	M, 16, M, 22,
	N, 232, N, 200,
	N, 0x0e, N, 0x0e,
	N, 0x8e, N, 0x8e,
	'c', 'c', 232, 'c', 'c', 'c',
	'C', 'C', 200, 'C', 'C', 'C',
};

const UBYTE key_space[] =
{
	M, 4,
	N, 0xa0,
	' ', '', '`', '^', '~', '',
};

CONST IPTR lokeymap[] =
{
	BYTES('~', '`', 176, ';'),		/* 00 Left of 1 Key */
	BYTES('!', '1', '1', '+'),		/* 01 1 */
	BYTES('@', '2', 204, 236),		/* 02 2 */
	BYTES('#', '3', 169, 185),		/* 03 3 */
	BYTES('$', '4', 200, 232),		/* 04 4 */
	BYTES('%', '5', 216, 248),		/* 05 5 */
	BYTES('^', '6', 174, 190),		/* 06 6 */
	BYTES('&', '7', 221, 253),		/* 07 7 */
	BYTES('*', '8', 193, 225),		/* 08 8 */
	BYTES('(', '9', 205, 237),		/* 09 9 */
	BYTES(')', '0', 201, 233),		/* 0A 0 */
	BYTES('_', 173, '%', '='),		/* 0B Right of 0 */
	BYTES('+', '=', 183, 180),		/* 0C 2nd right of 0 */
	BYTES('`', '', '`', 168),	   /* 0D 3rd right of 0 */
	BYTES(0, 0, 0, 0),			   /* 0E undefined */
	BYTES('0', '0', '0', '0'),		/* 0F NUM 0 */
	BYTES('@', '\\', 'Q', 'q'),		/* 10 */
	BYTES('W', '|', 'W', 'w'),		/* 11 */
	DEAD(key_e),		            /* 12 */
	DEAD(key_r),             		/* 13 */
	DEAD(key_t),		            /* 14 */
	DEAD(key_z),		            /* 15 */
	DEAD(key_u),		            /* 16 */
	DEAD(key_i),		            /* 17 */
	DEAD(key_o),		            /* 18 */
	BYTES('P', 'p', 'P', 'p'),		/* 19 */

	BYTES('{', '[', '/', 250),		/* 1A */
	BYTES('}', ']', '(', ')'),		/* 1B */
	BYTES(0, 0, 0, 0),			   /* 1C undefined */
	BYTES('1', '1', '1', '1'),		/* 1D NUM 1*/
	BYTES('2', '2', '2', '2'),		/* 1E NUM 2*/
	BYTES('3', '3', '3', '3'),		/* 1F NUM 3*/

	DEAD(key_a),		            /* 20 */
	DEAD(key_s),		            /* 21 */
	DEAD(key_d),      		      /* 22 */
	DEAD(key_f),	   		      /* 23 */
	DEAD(key_g),		   	      /* 24 */
	DEAD(key_h),		   	      /* 25 */
	DEAD(key_j),		   	      /* 26 */
	DEAD(key_k),		   	      /* 27 */
	BYTES(217, 249, 'L', 'l'),		/* 28 */

	BYTES(':', ';', '"', 249),		/* 29 */
	BYTES('"','\'', '!', 167),		/* 2A */
	BYTES('|','\\', '|','\\'),		/* 2B */
	BYTES(0, 0, 0, 0),			   /* 2C undefined */
	BYTES('4', '4', '4', '4'),		/* 2D NUM 4 */
	BYTES('5', '5', '5', '5'),		/* 2E NUM 5 */
	BYTES('6', '6', '6', '6'),		/* 2F NUM 6 */
	BYTES('|', '\\', '>', '<'),		/* 30 */
	DEAD(key_y),                  /* 31 */
	BYTES(172, '#', 'X', 'x'),		/* 32 */
	DEAD(key_c),                  /* 33 */
	BYTES(169, '@', 'V', 'v'),		/* 34 */
	BYTES('B', '{', 'B', 'b'),		/* 35 */
	DEAD(key_n),                  /* 36 */
	BYTES(165, 181, 'M', 'm'),		/* 37 */

	BYTES('<', '<', '?', ','),		/* 38 */
	BYTES('>', '>', ':', '.'),		/* 39 */
	BYTES('?', '/', '_', '-'),		/* 3A */
	BYTES(0, 0, 0, 0),	/* 3B */
	BYTES('.', '.', '.', '.'),		/* 3C NUM . */
	BYTES('7', '7', '7', '7'),		/* 3D NUM 7 */
	BYTES('8', '8', '8', '8'),		/* 3E NUM 8 */
	BYTES('9', '9', '9', '9'),		/* 3F NUM 9 */
};

#include "standard.h"

CONST IPTR hikeymap[] =
{
	DEAD(key_space),        /* 40 */
	BYTES(8, 8, 8, 8),		/* 41 BACKSPACE*/
	STRING(tab_descr),		/* 42 TAB */
	BYTES(13, 13, 13, 13),	/* 43 ENTER */
	BYTES(0, 0, 10, 13),	/* 44 RETURN */
	BYTES(0, 0, 0x9B, 27),	/* 45 ESCAPE */
	BYTES(127, 127, 127, 127),	/* 46 DEL */
	STRING(insert_descr),	/* 47 INSERT ?? */
	STRING(pageup_descr),	/* 48 PAGEUP ?? */
	STRING(pagedown_descr),	/* 49 PAGEDOWN ?? */
	BYTES('-', '-', '-', '-'),	/* 4A NUMPAD - */
	STRING(f11_descr),		/* 4B F11 ?? */
	STRING(up_descr),		/* 4C CURSOR UP*/
	STRING(down_descr),		/* 4D CURSOR DOWN*/
	STRING(right_descr),	/* 4E CURSOR RIGHT */
	STRING(left_descr),		/* 4F CURSOR LEFT */
	STRING(f1_descr),		/* 50 F1 */
	STRING(f2_descr),		/* 51 */
	STRING(f3_descr),		/* 52 */
	STRING(f4_descr),		/* 53 */
	STRING(f5_descr),		/* 54 */
	STRING(f6_descr),		/* 55 */
	STRING(f7_descr),		/* 56 */
	STRING(f8_descr),		/* 57 */
	STRING(f9_descr),		/* 58 */
	STRING(f10_descr),		/* 59 */
	BYTES(0, 0, 0, 0),		/* 5A */
	BYTES(0, 0, 0, 0),		/* 5B */
	BYTES('/', '/', '/', '/'),	/* 5C */
	BYTES('*', '*', '*', '*'),	/* 5D */
	BYTES('+', '+', '+', '+'),	/* 5E */
	STRING(help_descr),		/* 5F HELP */
	BYTES(0, 0, 0, 0),		/* 60 */
	BYTES(0, 0, 0, 0),		/* 61 */
	BYTES(0, 0, 0, 0),		/* 62 */
	BYTES(0, 0, 0, 0),		/* 63 */
	BYTES(0, 0, 0, 0),		/* 64 */
	BYTES(0, 0, 0, 0),		/* 65 */
	BYTES(0, 0, 0, 0),		/* 66 */
	BYTES(0, 0, 0, 0),		/* 67 */
	BYTES(0, 0, 0, 0),		/* 68 */
	BYTES(0, 0, 0, 0),		/* 69 */
	BYTES(0, 0, 0, 0),		/* 6A */
	STRING(scrlck_descr),	/* 6B */
	STRING(prtsc_descr),	/* 6C */
	STRING(numlock_descr),	/* 6D */
	STRING(pausebreak_descr),	/* 6E PAUSE/BREAK ?? */
	STRING(f12_descr),		/* 6F F12 ?? */
	STRING(home_descr),		/* 70 HOME ?? */
	STRING(end_descr),		/* 71 END ?? */
	BYTES(0, 0, 0, 0),		/* 72 */
	BYTES(0, 0, 0, 0),		/* 73 */
	BYTES(0, 0, 0, 0),		/* 74 */
	BYTES(0, 0, 0, 0),		/* 75 */
	BYTES(0, 0, 0, 0),		/* 76 */
	BYTES(0, 0, 0, 0),		/* 77 */
	BYTES(0, 0, 0, 0),		/* 78 */
	BYTES(0, 0, 0, 0),		/* 79 */
	BYTES(0, 0, 0, 0),		/* 7A */
	BYTES(0, 0, 0, 0),		/* 7B */
	BYTES(0, 0, 0, 0),		/* 7C */
	BYTES(0, 0, 0, 0),		/* 7D */
	BYTES(0, 0, 0, 0),		/* 7E */
	BYTES(0, 0, 0, 0),		/* 7F */
};

#undef SETBITS

#define SETBITS(b0, b1, b2, b3, b4, b5, b6, b7) \
	(b0<<0)|(b1<<1)|(b2<<2)|(b3<<3)|(b4<<4)|(b5<<5)|(b6<<6)|(b7<<7)

CONST UBYTE locapsable[] =
{
	SETBITS(0, 0, 1, 1, 1, 1, 1, 1),	/* 00 - 07 */
	SETBITS(1, 1, 1, 0, 0, 0, 0, 0),	/* 08 - 0F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
	SETBITS(1, 1, 0, 0, 0, 0, 0, 0),	/* 18 - 1F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
	SETBITS(1, 0, 0, 0, 0, 0, 0, 0),	/* 28 - 2F */

	SETBITS(0, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 38 - 3F */
};

CONST UBYTE hicapsable[] =
{
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 40 - 47 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 48 - 4F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 58 - 5F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

CONST UBYTE lorepeatable[] =
{
	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 00 - 07 */
	SETBITS(1, 1, 1, 1, 1, 1, 0, 1),	/* 08 - 0F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 10 - 17 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 18 - 1F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 20 - 27 */
	SETBITS(1, 1, 1, 1, 0, 1, 1, 1),	/* 28 - 2F */

	SETBITS(1, 1, 1, 1, 1, 1, 1, 1),	/* 30 - 37 */
	SETBITS(1, 1, 1, 0, 1, 1, 1, 1)	/* 38 - 3F */
};

CONST UBYTE hirepeatable[] =
{
	SETBITS(1, 1, 1, 0, 0, 0, 1, 0),	/* 40 - 47 */
	SETBITS(1, 1, 1, 0, 1, 1, 1, 1),	/* 48 - 4F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 50 - 57 */
	SETBITS(0, 0, 1, 1, 1, 1, 1, 0),	/* 58 - 5F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 60 - 67 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 68 - 6F */

	SETBITS(0, 0, 0, 0, 0, 0, 0, 0),	/* 70 - 77 */
	SETBITS(0, 0, 0, 0, 0, 0, 0, 0)	/* 78 - 7F */
};

#include "iso-8859-2.c"
#include "query.c"
